package data.missions.swp_magnificent7;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.ids.Factions;
import com.fs.starfarer.api.impl.campaign.ids.ShipRoles;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.SWP_FleetFactory;
import data.scripts.campaign.SWP_FleetFactory.FleetFactoryDelegate;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition implements MissionDefinitionPlugin {

	public static final String ENEMY_FACTION_ID = Factions.PIRATES;	// Factions.LUDDIC_PATH;
	public static final int ENEMY_FLEET_SIZE = 27;
	protected static final List<String> FACTIONS = new ArrayList<>();
	protected FactionAPI currentFaction = null;
	protected WeightedRandomPicker<String> factionPicker = new WeightedRandomPicker();
	
	protected static void initFactions()
	{
		FACTIONS.clear();
		FACTIONS.add(Factions.HEGEMONY);
		FACTIONS.add(Factions.TRITACHYON);
		FACTIONS.add(Factions.INDEPENDENT);
		addFactionIfExists("interstellarimperium");
		addFactionIfExists("citadeldefenders");
		addFactionIfExists("blackrock_driveyards");
		addFactionIfExists("exigency");
		addFactionIfExists("shadow_industry");
		addFactionIfExists("mayorate");
		addFactionIfExists("pack");
		addFactionIfExists("tiandong");
		addFactionIfExists("diableavionics");
		addFactionIfExists("SCY");
		addFactionIfExists("ORA");
		addFactionIfExists("dassault_mikoyan");
		addFactionIfExists("Coalition");	// Tyrador
		addFactionIfExists("pbc");
		addFactionIfExists("neutrinocorp");
	}
	
	protected static void addFactionIfExists(String factionId)
	{
		if (Global.getSector().getFaction(factionId) != null)
			FACTIONS.add(factionId);
	}
	
	protected String getRole(String type)
	{
		WeightedRandomPicker<String> picker = new WeightedRandomPicker<>();
		switch (type)
		{
			case "cruiser":
				picker.add(ShipRoles.COMBAT_LARGE, 15);
				picker.add(ShipRoles.CARRIER_MEDIUM, 3);
			case "destroyer":
				picker.add(ShipRoles.COMBAT_MEDIUM, 10);
				picker.add(ShipRoles.ESCORT_MEDIUM, 5);
				break;
			case "frigate":
				picker.add(ShipRoles.COMBAT_SMALL, 12);
				picker.add(ShipRoles.ESCORT_SMALL, 5);
				picker.add(ShipRoles.FAST_ATTACK, 5);
				break;
			case "carrier":
				return ShipRoles.CARRIER_SMALL;
		}
		return picker.pick();
	}
	
	protected String getRandomFaction()
	{
		if (factionPicker.isEmpty())
			factionPicker.addAll(FACTIONS);
		return factionPicker.pickAndRemove();
	}
	
	protected String getPlayerShip(String type)
	{
		currentFaction = Global.getSector().getFaction(getRandomFaction());
		float quality = MathUtils.getRandomNumberInRange(0.8f, 1);
		List<ShipRolePick> picks = currentFaction.pickShip(getRole(type), quality);
		if (picks.isEmpty())
			return getPlayerShip(type);	// try again with a different faction
		
		return picks.get(0).variantId;
	}
	
	protected void addPlayerShip(MissionDefinitionAPI api, String type, String name, String personality,  boolean isFlagship)
	{
		String variantId = getPlayerShip(type);
		FleetMemberAPI member = api.addToFleet(FleetSide.PLAYER, variantId, FleetMemberType.SHIP, name, isFlagship);
		if (isFlagship) api.defeatOnShipLoss(name);
		// officers
		/*
		int level = 10;
		if (isFlagship) level = 15;
		PersonAPI officer = OfficerManagerEvent.createOfficer(currentFaction, level);
		if (isFlagship)
		{
			officer.getName().setFirst("Izanami");
			officer.getName().setFirst("Mifune");
			officer.getName().setGender(FullName.Gender.FEMALE);
			officer.setPortraitSprite("graphics/portraits/portrait_league00.png");
		}
		officer.setFaction(Factions.INDEPENDENT);
		officer.setPersonality(personality);
		member.setCaptain(officer);
		float maxCR = member.getRepairTracker().getMaxCR();
		member.getRepairTracker().setCR(maxCR);
		*/
	}
	
	protected void addPlayerShip(MissionDefinitionAPI api, String type, String name, String personality)
	{
		addPlayerShip(api, type, name, personality, false);
	}

    @Override
    public void defineMission(MissionDefinitionAPI api) {
		initFactions();
		
        api.initFleet(FleetSide.PLAYER, "ISS", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "Seven brave samurai");
        api.setFleetTagline(FleetSide.ENEMY, "Pirate Pillager Fleet");

        if (!SWPModPlugin.hasUnderworld) {
            api.addBriefingItem("UNDERWORLD REQUIRED");
            api.addBriefingItem("Download Underworld to play this mission!");
        }

        if (!SWPModPlugin.hasUnderworld) {
            return;
        } else {
            api.addBriefingItem("Defeat the attackers");
			api.addBriefingItem("The ISS Yojimbo must survive");
			//api.addBriefingItem("All friendly captains are highly skilled");
			api.addBriefingItem("Click mission to re-roll ships (more available with different mods)");
        }

        addPlayerShip(api, "cruiser", "ISS Yojimbo", "steady", true);
		addPlayerShip(api, "cruiser", "ISS Palisade", "aggressive");
		addPlayerShip(api, "destroyer", "ISS True Love Kiss", "steady");
		addPlayerShip(api, "destroyer", "ISS Aloysha Popovich", "steady");
		addPlayerShip(api, "frigate", "ISS Sound of Silence", "aggressive");
		addPlayerShip(api, "frigate", "ISS Defiant", "steady");
		addPlayerShip(api, "carrier", "ISS Maia", "cautious");
		
		MarketAPI market = Global.getFactory().createMarket("fake_market", "Fake market", 7);
		FactionAPI enemyFaction = Global.getSector().getFaction(ENEMY_FACTION_ID);
		
		final FleetParams params = new FleetParams(new Vector2f(0, 0),
                market,
                ENEMY_FACTION_ID,
				null,
                "missionFleet",
                ENEMY_FLEET_SIZE, // combatPts
                0f, // freighterPts
                0f, // tankerPts
                0f, // transportPts
                0f, // linerPts
                0f, // civilianPts
                0f, // utilityPts
                0f, // qualityBonus
                0.8f, // qualityOverride
                0, // officer num mult
                0); // officer level bonus
        params.withOfficers = false;
		

        CampaignFleetAPI fleet = SWP_FleetFactory.enhancedCreateFleet(enemyFaction, ENEMY_FLEET_SIZE,
                new FleetFactoryDelegate() {
            @Override
            public CampaignFleetAPI createFleet() {
                return FleetFactoryV2.createFleet(params);
            }
        });
		for (FleetMemberAPI member : fleet.getFleetData().getMembersInPriorityOrder())
		{
			api.addFleetMember(FleetSide.ENEMY, member);
		}
		
        float width = 16000f;
        float height = 14000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        for (int i = 0; i < 8; i++) {
            float x = (float) Math.random() * width - width / 2;
            float y = (float) Math.random() * height - height / 2;
            float radius = 100f + (float) Math.random() * 400f;
            api.addNebula(x, y, radius);
        }

        api.addObjective(width * 0.4f, -height * 0.2f, "nav_buoy");
        api.addObjective(-width * 0.4f, height * 0.15f, "sensor_array");
		api.addObjective(0, 0, "comm_relay");

        api.addAsteroidField(0f, 0f, 45f, width, 20f, 70f, 250);
		
		// Nomios
		api.addPlanet(0, 0, 250f, "frozen", 350f, true);
    }
}
